<?php
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

require '../src/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = $_SESSION['user']['id'];
    $texto = trim($_POST['texto'] ?? '');
    
    if (empty($texto)) {
        $_SESSION['flash'] = 'El texto de la publicación no puede estar vacío.';
        header('Location: dashboard.php?tab=feed');
        exit;
    }
    
    $mediaFileName = null;
    $tipo = null;
    
    // Manejar archivo multimedia si se subió
    if (isset($_FILES['media']) && $_FILES['media']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'uploads/posts/';
        
        // Crear directorio si no existe
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        $originalName = $_FILES['media']['name'];
        $extension = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));
        
        // Validar tipo de archivo
        $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'bmp'];
        $videoExtensions = ['mp4', 'avi', 'mov', 'wmv', 'flv', 'webm'];
        
        if (in_array($extension, $imageExtensions)) {
            $tipo = 'imagen';
        } elseif (in_array($extension, $videoExtensions)) {
            $tipo = 'video';
        } else {
            $_SESSION['flash'] = 'Tipo de archivo no permitido. Solo se permiten imágenes y videos.';
            header('Location: dashboard.php?tab=feed');
            exit;
        }
        
        // Generar nombre único para el archivo
        $mediaFileName = time() . '_' . uniqid() . '.' . $extension;
        $uploadPath = $uploadDir . $mediaFileName;
        
        // Mover archivo subido
        if (!move_uploaded_file($_FILES['media']['tmp_name'], $uploadPath)) {
            $_SESSION['flash'] = 'Error al subir el archivo multimedia.';
            header('Location: dashboard.php?tab=feed');
            exit;
        }
    }
    
    try {
        // Insertar publicación en la base de datos
        $stmt = $pdo->prepare("
            INSERT INTO publicaciones (usuario_id, texto, media, tipo, fecha) 
            VALUES (?, ?, ?, ?, NOW())
        ");
        
        $stmt->execute([$userId, $texto, $mediaFileName, $tipo]);
        
        $_SESSION['flash'] = 'Publicación creada exitosamente.';
        
    } catch (PDOException $e) {
        // En caso de error, eliminar el archivo si se subió
        if ($mediaFileName && file_exists($uploadDir . $mediaFileName)) {
            unlink($uploadDir . $mediaFileName);
        }
        
        $_SESSION['flash'] = 'Error al crear la publicación: ' . $e->getMessage();
    }
    
} else {
    $_SESSION['flash'] = 'Método no permitido.';
}

// Redirigir siempre a la sección de publicaciones
header('Location: index.php?tab=feed');
exit;
?>