<?php
session_start();
require '../src/db.php';

if (isset($_SESSION['user'])) {
    header('Location: index.php');
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $passw = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($passw, $user['password'])) {
        $_SESSION['user'] = $user;
        header('Location: index.php');
        exit;
    } else {
        $error = "Email o contraseña incorrectos.";
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Login | Biblioteca Virtual</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
 body {
  background: linear-gradient(to right, #f5f7fa, #c3cfe2);
  font-family: 'Segoe UI', sans-serif;
  margin: 0;
}

.logo {
  width: 60px;
  height: 60px;
}

.titulo-app {
  font-size: 1.8rem;
  font-weight: 600;
  margin-bottom: 0.4rem;
}

.subtitle-app {
  font-size: 1rem;
  color: #666;
  margin-bottom: 1rem;
}

.login-card {
  background: #fff;
  border-radius: 16px;
  padding: 1rem;
  /* box-shadow: 0 0 20px rgba(0,0,0,0.1); */
  text-align: center;
}

.login-card .form-control {
  border-radius: 10px;
}

.login-card .btn {
  border-radius: 10px;
}

.small-text {
  font-size: 0.85rem;
  color: #888;
  margin-top: 1.5rem;
}

@media (max-width: 576px) {
  .login-card {
    padding: 1.5rem;
  }

  .titulo-app {
    font-size: 1.5rem;
  }

  .subtitle-app {
    font-size: 0.9rem;
  }

  .logo {
    width: 48px;
    height: 48px;
  }
}
  </style>
</head>
<body>
  <main class="container-fluid min-vh-100 d-flex flex-column justify-content-center align-items-center p-4">

    <div class="text-center mb-4">
      <img src="https://cdn-icons-png.freepik.com/512/234/234648.png" alt="Logo" class="logo">
      <h1 class="titulo-app">Biblioteca Virtual</h1>
      <p class="subtitle-app">Tu colección personal de libros digitales</p>
    </div>


    <div class="login-card w-100" style="max-width: 25%;">
      <div class="login-card">    
    <h5 class="mb-3">¡Bienvenido!</h5>
    <p class="mb-4 text-muted">Inicia sesión o crea una cuenta para comenzar</p>

    <?php if ($error): ?>
      <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="post" novalidate>
      <div class="mb-3 text-start">
        <label for="email" class="form-label">Email</label>
        <input type="email" id="email" name="email"
               class="form-control" required>
      </div>
      <div class="mb-4 text-start">
        <label for="password" class="form-label">Contraseña</label>
        <input type="password" id="password" name="password"
               class="form-control" required>
      </div>
      <div class="d-grid gap-2">
        <button type="submit" class="btn btn-primary">
          Iniciar Sesión
        </button>
        <a href="register.php" class="btn btn-outline-secondary">
          Registrarse
        </a>
      </div>
    </form>

    <div class="small-text">Descubre, lee y anota tus libros favoritos.</div>
  </div>
    </div>

  </div>
</body>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>