<?php
// public/edit_book.php
session_start();
require '../src/db.php';

// preparar dirs
$pdfDir = __DIR__ . '/uploads/pdfs';
$imgDir = __DIR__ . '/uploads/portadas';
foreach([$pdfDir, $imgDir] as $d) {
  if (!is_dir($d)) mkdir($d,0777,true);
}

// recoger datos
$id          = intval($_POST['id'] ?? 0);
$titulo      = trim($_POST['titulo'] ?? '');
$autor       = trim($_POST['autor'] ?? '');
$categoria   = intval($_POST['categoria'] ?? 0);
$descripcion = trim($_POST['descripcion'] ?? '');

// validación mínima
if ($id && $titulo && $autor && $categoria) {
  $params = [$titulo, $autor, $categoria, $descripcion];
  $sql    = "UPDATE libros 
             SET titulo = ?, autor = ?, categoria_id = ?, descripcion = ?";

  // si sube nuevo PDF
  if (!empty($_FILES['pdf']['tmp_name'])) {
    $pdfName = uniqid() . '_' . basename($_FILES['pdf']['name']);
    if (move_uploaded_file($_FILES['pdf']['tmp_name'], "$pdfDir/$pdfName")) {
      $sql      .= ", archivo = ?";
      $params[]  = $pdfName;
    }
  }

  // si sube nueva portada
  if (!empty($_FILES['portada']['tmp_name'])) {
    $imgName = uniqid() . '_' . basename($_FILES['portada']['name']);
    if (move_uploaded_file($_FILES['portada']['tmp_name'], "$imgDir/$imgName")) {
      $sql      .= ", portada = ?";
      $params[]  = $imgName;
    }
  }

  $sql .= " WHERE id = ?";
  $params[] = $id;
  $stmt = $pdo->prepare($sql);
  $stmt->execute($params);

  $_SESSION['flash'] = "Libro actualizado correctamente.";
}

// redirigir de vuelta al listado
$tab = $_GET['tab'] ?? 'books';
header("Location: index.php?tab={$tab}");
exit;