<?php
session_start();
if (!isset($_SESSION['user'])) {
  header('Location: login.php');
  exit;
}
require '../src/db.php';

// Cargar libros y categorías para el formulario
$books = $pdo->query("
  SELECT l.*, c.nombre AS categoria
  FROM libros l
  JOIN categorias c ON c.id = l.categoria_id
")->fetchAll();

$cats = $pdo->query("SELECT * FROM categorias")->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Dashboard | Biblioteca Virtual</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="style.css">
</head>
<body>

  <!-- Navbar -->
  <nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
    <div class="container-fluid">
      <a class="navbar-brand" href="#">Biblioteca</a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
              data-bs-target="#navMenu" aria-controls="navMenu">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="navMenu">
        <ul class="navbar-nav me-auto mb-2 mb-lg-0">
          <li class="nav-item">
            <a class="nav-link active" href="#" onclick="showSection('books')">Libros</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#" onclick="showSection('notes')">Anotaciones</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#" onclick="showSection('chat')">Chat</a>
          </li>
        </ul>
        <a href="logout.php" class="btn btn-outline-light">Cerrar sesión</a>
      </div>
    </div>
  </nav>

  <main class="container py-4">

    <!-- SECTION: Libros -->
    <section id="section-books">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>Libros</h2>
        <a href="add_book.php" class="btn btn-secondary">
          + Agregar Libro
        </a>
      </div>

      <div class="input-group mb-4">
        <span class="input-group-text">🔍</span>
        <input type="text" id="search-input"
               class="form-control"
               placeholder="Buscar por título o autor…"
               onkeyup="filterBooks()">
      </div>

      <div class="row" id="books-container">
        <?php foreach ($books as $b): ?>
          <div class="col-md-4 mb-4 book-card">
            <div class="card h-100 card-book">
              <img src="uploads/portadas/<?= htmlspecialchars($b['portada']) ?>"
                   class="card-img-top"
                   alt="Portada de <?= htmlspecialchars($b['titulo']) ?>">
              <div class="card-body d-flex flex-column">
                <h5 class="card-title"><?= htmlspecialchars($b['titulo']) ?></h5>
                <p class="card-text mb-1">
                  <small class="text-muted"><?= htmlspecialchars($b['autor']) ?></small>
                </p>
                <p class="mb-2">
                  <span class="badge bg-secondary">
                    <?= htmlspecialchars($b['categoria']) ?>
                  </span>
                </p>
                <a href="uploads/pdfs/<?= htmlspecialchars($b['archivo']) ?>"
                   target="_blank"
                   class="mt-auto btn btn-outline-primary">
                  Ver PDF
                </a>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </section>

    <!-- SECTION: Anotaciones -->
    <section id="section-notes" style="display:none;">
      <h2>Anotaciones</h2>
      <!-- Aquí tu lógica de anotaciones -->
      <p class="text-muted">Próximamente…</p>
    </section>

    <!-- SECTION: Chat -->
    <section id="section-chat" style="display:none;">
      <h2>Chat</h2>
      <div id="chat-box"
           class="border bg-light mb-3 p-3"
           style="height:300px; overflow-y:auto;"></div>
      <div class="input-group">
        <input type="text" id="user-input" class="form-control"
               placeholder="Escribe tu pregunta…">
        <button class="btn btn-primary" onclick="enviarMensaje()">
          Enviar
        </button>
      </div>
    </section>

  </main>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Muestra u oculta secciones
    function showSection(sec) {
      ['books','notes','chat'].forEach(s => {
        document.getElementById('section-'+s)
                .style.display = (s===sec ? 'block' : 'none');
      });
    }
    // Filtrar tarjetas de libros
    function filterBooks() {
      const q = document.getElementById('search-input')
                     .value.toLowerCase();
      document.querySelectorAll('.book-card').forEach(card => {
        const text = card.innerText.toLowerCase();
        card.style.display = text.includes(q) ? '' : 'none';
      });
    }
  </script>
  <script src="chat.js"></script>
</body>
</html>