document.addEventListener('DOMContentLoaded', () => {
  const input = document.getElementById('user-input');
  // Enter para enviar, Shift+Enter para salto
  input.addEventListener('keydown', function(e) {
    if (e.key === 'Enter' && !e.shiftKey) {
      e.preventDefault();
      enviarMensaje();
    }
  });
});

function appendMessage(text, sender) {
  console.log('Mensaje recibido:', JSON.stringify(text)); // DEBUG
  
  // No escapar HTML aquí si ya viene procesado del servidor
  // Solo convertir saltos de línea a <br> si no están ya convertidos
  let processedText = text;
  
  // Si no contiene <br> tags, convertir \n a <br>
  if (!processedText.includes('<br>') && !processedText.includes('<br/>')) {
    processedText = processedText.replace(/\n/g, '<br>');
  }

  const chatBox = document.getElementById('chat-box');
  const wrapper = document.createElement('div');
  wrapper.classList.add('message', sender === 'usuario' ? 'user' : 'bot');

  const bubble = document.createElement('div');
  bubble.classList.add('message-content');
  bubble.innerHTML = processedText;

  wrapper.appendChild(bubble);
  chatBox.appendChild(wrapper);
  chatBox.scrollTop = chatBox.scrollHeight;
}

function enviarMensaje() {
  const inputEl = document.getElementById('user-input');
  const texto   = inputEl.value.trim();
  if (!texto) return;
  inputEl.value = '';

  // Mensaje usuario
  appendMessage(texto, 'usuario');

  // Guardar usuario
  fetch('chat_store.php', {
    method: 'POST',
    headers: {'Content-Type':'application/json'},
    body: JSON.stringify({ message: texto, sender: 'usuario' })
  });

  // Llamada al webhook
  fetch('https://n8n.automatizaperu.pro/webhook/8dae3beb-d320-4532-b639-c0f08e8f94fa', {
    method: 'POST',
    headers: {'Content-Type':'application/json'},
    body: JSON.stringify({ prompt: texto })
  })
  .then(r => r.json())
  .then(data => {
    const resp = data.respuesta;
    // Mensaje asistente - CAMBIO AQUÍ: usar 'assistant' en lugar de 'bot'
    appendMessage(resp, 'bot');

    // Guardar asistente - CAMBIO AQUÍ: usar 'assistant' en lugar de 'bot'
    // Guardar asistente - cambiar 'assistant' por 'bot'
    fetch('chat_store.php', {
      method: 'POST',
      headers: {'Content-Type':'application/json'},
      body: JSON.stringify({ message: resp, sender: 'bot' })
    });
  })
  .catch(() => {
    appendMessage('Error: no se obtuvo respuesta.', 'assistant');
  });
}