<?php
// public/book_handler.php
session_start();
require '../src/db.php';
header('Content-Type: application/json');

$response = ['success'=>false, 'errors'=>[]];

// Directorios de subida
$pdfDir  = __DIR__ . '/uploads/pdfs';
$imgDir  = __DIR__ . '/uploads/portadas';
foreach ([$pdfDir, $imgDir] as $d) {
  if (!is_dir($d)) mkdir($d, 0777, true);
}

// 1) DELETE por JSON
$ct = $_SERVER['CONTENT_TYPE'] ?? '';
if ($_SERVER['REQUEST_METHOD']==='POST' && strpos($ct,'application/json')!==false) {
  $req = json_decode(file_get_contents('php://input'), true);
  if (!empty($req['delete_book']) && !empty($req['book_id'])) {
    $stmt = $pdo->prepare("DELETE FROM libros WHERE id = ?");
    if ($stmt->execute([$req['book_id']])) {
      $response['success'] = true;
    }
  }
  echo json_encode($response);
  exit;
}

// 2) CREATE / UPDATE via FormData
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $id          = !empty($_POST['book_id']) ? intval($_POST['book_id']) : null;
  $titulo      = trim($_POST['titulo'] ?? '');
  $autor       = trim($_POST['autor'] ?? '');
  $categoria   = intval($_POST['categoria'] ?? 0);
  $descripcion = trim($_POST['descripcion'] ?? '');

  // Validaciones
  if (!$titulo)    $response['errors'][] = 'Título obligatorio';
  if (!$autor)     $response['errors'][] = 'Autor obligatorio';
  if (!$categoria) $response['errors'][] = 'Categoría obligatoria';

  // Archivos
  $pdfName = null;
  if (!empty($_FILES['pdf']['tmp_name'])) {
    $pdfName = uniqid().'_'.basename($_FILES['pdf']['name']);
    if (!move_uploaded_file($_FILES['pdf']['tmp_name'], "$pdfDir/$pdfName")) {
      $response['errors'][] = 'Error subiendo PDF';
    }
  }
  $imgName = null;
  if (!empty($_FILES['portada']['tmp_name'])) {
    $imgName = uniqid().'_'.basename($_FILES['portada']['name']);
    if (!move_uploaded_file($_FILES['portada']['tmp_name'], "$imgDir/$imgName")) {
      $response['errors'][] = 'Error subiendo portada';
    }
  }

  if (empty($response['errors'])) {
    if ($id) {
      // UPDATE
      $sql    = "UPDATE libros 
                 SET titulo=?, autor=?, categoria_id=?, descripcion=?";
      $params = [$titulo, $autor, $categoria, $descripcion];
      if ($pdfName)    { $sql .= ", archivo=?";    $params[] = $pdfName; }
      if ($imgName)    { $sql .= ", portada=?";     $params[] = $imgName; }
      $sql   .= " WHERE id=?";
      $params[] = $id;
      $stmt = $pdo->prepare($sql);
      if ($stmt->execute($params)) {
        $response['success'] = true;
      }
    } else {
      // INSERT
      if (!$pdfName)  $response['errors'][] = 'PDF obligatorio';
      if (!$imgName)  $response['errors'][] = 'Portada obligatoria';

      if (empty($response['errors'])) {
        $stmt = $pdo->prepare("
          INSERT INTO libros 
            (titulo, autor, categoria_id, descripcion, archivo, portada)
          VALUES (?, ?, ?, ?, ?, ?)
        ");
        if ($stmt->execute([
          $titulo, $autor, $categoria, $descripcion,
          $pdfName, $imgName
        ])) {
          $response['success'] = true;
        }
      }
    }
  }

  echo json_encode($response);
  exit;
}

// Default
echo json_encode($response);