<?php
session_start();

if (!isset($_SESSION['user'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

require '../src/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['comentario']) && isset($_POST['post_id'])) {
    $comentario = trim($_POST['comentario']);
    $postId = (int)$_POST['post_id'];
    $userId = $_SESSION['user']['id'];
    
    if (empty($comentario)) {
        http_response_code(400);
        echo json_encode(['error' => 'El comentario no puede estar vacío']);
        exit;
    }
    
    try {
        // Insertar comentario
        $stmt = $pdo->prepare("
            INSERT INTO comentarios_post (post_id, usuario_id, texto, fecha) 
            VALUES (?, ?, ?, NOW())
        ");
        $stmt->execute([$postId, $userId, $comentario]);
        
        // Obtener el comentario recién creado con el autor
        $commentId = $pdo->lastInsertId();
        $stmt = $pdo->prepare("
            SELECT c.texto, c.fecha, u.email AS autor
            FROM comentarios_post c
            JOIN usuarios u ON u.id = c.usuario_id
            WHERE c.id = ?
        ");
        $stmt->execute([$commentId]);
        $newComment = $stmt->fetch();
        
        echo json_encode([
            'success' => true,
            'comment' => $newComment
        ]);
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al agregar comentario']);
    }
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Datos inválidos']);
}
?>